function mpc = Network3																										
%% INESC TEC 06/07/2020																										
%% MATPOWER Case Format : Version 2																										
mpc.version = '2';																										
																										
%%-----  Power Flow Data  -----%%																										
%% system MVA base																										
mpc.baseMVA = 100;																										
																										
%% system voltage levels (kV)																										
mpc.V_levels = [																										
	10	60																								
];																										
																										
%% bus data																										
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	hasGEN	isLOAD	SNOM_MVA	SX	SY	GX	GY						
mpc.bus = [																										
	1	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0	0	0	0	0;						
	2	3	0	0	0.014	0	1	1	0	60	1	1.1	0.9	1	0	0	0	0	0	0;						
	3	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	4	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	5	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	6	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	7	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	8	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	9	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	10	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	11	1	0.243	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	12	1	0.21	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	13	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	14	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	15	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	16	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	17	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	18	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	19	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	20	1	0.212	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	21	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	22	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	23	1	0.384	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	24	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	25	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	26	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	27	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	28	1	0.94	0	0	0	1	1	0	10	1	1.1	0.9	0	1	2.25	0	0	0	0;						
	29	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	30	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	31	1	0.26	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	32	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	33	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	34	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	35	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	36	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	37	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	38	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	39	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	40	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	41	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	42	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	43	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	44	1	0.0791	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.2	0	0	0	0;						
	45	1	0.0073	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	46	1	0.0292	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	47	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	48	1	0.0056	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.2	0	0	0	0;						
	49	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	50	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	51	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	52	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	53	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	54	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	55	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	56	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	57	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	58	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	59	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	60	1	0.0142	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	61	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	2.28	0	0	0	0;						
	62	1	0.0525	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	63	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	64	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	65	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	66	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	67	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	68	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	69	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	70	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	71	1	0.0704	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	72	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	73	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	74	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	75	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	76	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	77	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	78	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	79	1	0.219	0	0	0	1	1	0	10	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	80	1	0.144	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	81	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	82	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.32	0	0	0	0;						
	83	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	84	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	85	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	86	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	87	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	88	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	89	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	90	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	91	1	0.957	0	0	0	1	1	0	10	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	92	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	93	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	94	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	1	0	0	0	0;						
	95	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	96	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	97	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	98	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	99	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	100	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	101	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	102	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	103	1	0.473	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	104	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	105	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	106	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	107	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	108	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	109	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	110	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	111	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	112	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	113	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	114	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	115	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	116	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	117	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	118	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	119	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	120	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	121	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	122	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	123	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	124	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	125	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	126	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	127	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	128	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	129	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	130	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	131	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	132	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	133	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	134	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	135	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	136	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	137	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	138	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	139	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	140	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	141	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	142	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	143	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	144	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	145	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	146	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	147	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	148	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	149	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	150	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	151	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	152	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	153	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	154	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	155	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	156	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	157	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	158	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	159	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	160	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	161	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	162	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	163	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	164	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	165	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	166	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	167	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	168	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	169	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	170	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	171	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	172	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	173	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	174	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	175	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	176	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	177	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	178	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	179	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	180	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	181	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	182	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	183	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	184	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	185	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	186	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	187	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	188	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	189	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	190	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	191	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	192	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	193	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	194	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	195	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	196	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	197	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	198	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	199	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	200	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	201	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	202	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	203	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	204	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	205	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	206	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	207	1	0	0	0	0	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
];																										
																										
%% generator data																										
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	ID				
mpc.gen = [																										
	2	0	0	10000	-10000	1	100	1	9999	-9999	0	0	0	0	0	0	0	0	0	0	0	1;				
];																										
																										
%% branch data																										
%	fbus	tbus	r	x	b	rateA (typical)	rateB (summer)	rateC (winter)	ratio	angle	status	angmin	angmax	step_size	actTap	minTap	maxTap	normalTap	nominalRatio	r_ip	r_n	r0	x0	b0	length (meter)	NormSTAT
mpc.branch = [																										
	111	110	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	112	111	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	181	180	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	140	139	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	91	183	0	0.0001	0	173	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.26	1;
	137	136	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	186	184	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	167	163	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	179	140	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	95	156	0	0.0001	0	173	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.32	1;
	135	134	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	122	121	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	170	162	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	171	166	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	173	169	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	166	165	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	185	129	0.0000063	0.0001	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.04	1;
	130	109	0.0000063	0.0001	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.04	1;
	129	108	0.0000063	0.0001	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.04	1;
	202	201	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	146	145	0.0000063	0.0001	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.04	1;
	127	126	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	159	158	0	0.0001	0	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	160	159	0	0.0001	0	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	200	161	0	0.0001	0	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	192	187	0	0.0001	0	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	196	192	0	0.0001	0	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	207	205	0	0.0001	0	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	118	116	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	200	187	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	207	116	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	61	156	0	0.0001	0	173	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.22	1;
	154	114	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	155	154	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	155	152	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	120	119	0.0000063	0.0001	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.04	1;
	145	144	0.0000063	0.0001	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.04	1;
	132	131	0.0000126	0.0001	2.66E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000126	0.0000276	2.66E-10	0.08	1;
	150	149	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	158	150	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	115	113	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	153	115	0	0.0001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	153	107	0	0.0001	0	173	173	173	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	161	160	0	0.0001	0	173	173	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	2	1	0.0154	0.5	0	20	20	20	1.0007	0	1	-360	360	1.5027	12	1	23	12	0.9508	0	0	0.0154	0.45	0	0	1;
	162	171	0	0.0002	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	194	142	0	0.0002	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	142	143	0	0.0002	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	138	126	0	0.0002	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.08	1;
	205	196	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.14	1;
	13	130	0	0.0005	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	4.4	1;
	68	108	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.3	1;
	185	66	0.0000063	0.0004	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.34	1;
	109	108	0.0000189	0.0008	4E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000189	0.0000414	4E-10	0.22	1;
	185	81	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.3	1;
	114	42	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	172	89	0.0000063	0.0004	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.14	1;
	154	38	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	113	3	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	124	21	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.2	1;
	182	90	0.0000063	0.0004	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.14	1;
	129	67	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.3	1;
	198	94	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.17	1;
	182	157	0.0477	0.0293	0.0000462	6.04	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.325	0.164	0.0000462	324.3	1;
	12	199	0.00000158	0.0007	3.33E-11	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00000158	0.00000345	3.33E-11	6.5	1;
	157	156	0.00000158	0.0006	3.33E-11	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00000158	0.00000345	3.33E-11	0.08	1;
	71	206	0	0.0007	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.6	1;
	200	1	0	0.0008	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.13	1;
	22	131	0.0000063	0.0006	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.07	1;
	135	19	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	30	135	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.26	1;
	126	25	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.15	1;
	53	140	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	49	168	0	0.0005	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.15	1;
	26	127	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.15	1;
	182	172	0.135	0.0795	0.000122	6.04	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.882	0.441	0.000122	872.69	1;
	199	158	0.141	0.0824	0.000123	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.897	0.447	0.000123	885.3	1;
	172	105	0.0536	0.0325	0.0000483	6.04	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.349	0.175	0.0000483	349.04	1;
	137	102	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.22	1;
	137	101	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.14	1;
	11	123	0.000011	0.0004	2.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000011	0.0000242	2.33E-10	6.32	1;
	98	134	0.128	0.0746	0.000111	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.81	0.404	0.000111	799.09	1;
	136	43	0.0308	0.0191	0.0000267	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.195	0.0973	0.0000267	204.2	1;
	20	127	0	0.0013	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	4.49	1;
	122	15	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.2	1;
	169	36	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.15	1;
	122	16	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.32	1;
	29	113	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.34	1;
	5	115	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.34	1;
	33	169	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.19	1;
	147	46	0.0000063	0.0005	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	6.48	1;
	17	188	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.14	1;
	34	173	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.27	1;
	153	4	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.34	1;
	39	155	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.5	1;
	41	114	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.26	1;
	174	64	0.0000063	0.0004	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.14	1;
	141	82	0.0000063	0.0008	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.22	1;
	176	65	0.00000473	0.0006	9.99E-11	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00000473	0.0000104	9.99E-11	0.23	1;
	178	44	0.00319	0.00332	0.00000276	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0202	0.0101	0.00000276	30.92	1;
	79	148	0.0000063	0.0007	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	6.31	1;
	57	162	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	24	164	0	0.0005	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	3.07	1;
	170	54	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	164	165	0	0.0005	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	165	55	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	58	166	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	171	56	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.38	1;
	199	198	0.153	0.0884	0.000132	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.97	0.483	0.000132	957.07	1;
	7	163	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.17	1;
	163	6	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.13	1;
	31	195	0.000011	0.0004	2.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000011	0.0000242	2.33E-10	6.31	1;
	167	134	0.0377	0.0225	0.0000327	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.239	0.119	0.0000327	237.69	1;
	170	27	0	0.0005	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.42	1;
	173	138	0.0098	0.0068	0.00000849	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0622	0.031	0.00000849	64.33	1;
	123	197	0.049	0.0292	0.0000425	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.311	0.155	0.0000425	310.72	1;
	70	197	0.0000063	0.0006	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.07	1;
	47	175	0.00000158	0.0006	3.33E-11	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00000158	0.00000345	3.33E-11	0.04	1;
	181	59	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.19	1;
	139	104	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	128	14	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	180	192	0.398	0.229	0.000345	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	2.53	1.26	0.000345	2484.5	1;
	181	63	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.23	1;
	177	168	0.011	0.0079	0.0000102	6.27	5.8717	6.5991	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0737	0.0371	0.0000102	84.12	1;
	147	151	0.0206	0.0129	0.0000179	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.131	0.0653	0.0000179	133.85	1;
	184	180	0.0793	0.0465	0.0000687	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.504	0.251	0.0000687	498.46	1;
	186	88	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.24	1;
	139	52	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.26	1;
	186	69	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.28	1;
	50	178	0.00000788	0.0007	1.67E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00000788	0.0000173	1.67E-10	0.09	1;
	106	72	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	124	106	0.0199	0.0126	0.0000173	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.127	0.0631	0.0000173	127.53	1;
	118	183	0.124	0.0735	0.000108	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.789	0.393	0.000108	783.58	1;
	92	183	0.00808	0.00467	0.00000701	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0513	0.0256	0.00000701	53.49	1;
	23	189	0.0000063	0.0005	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	6.33	1;
	112	74	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.24	1;
	184	110	0.0237	0.0147	0.0000206	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.151	0.0751	0.0000206	150.93	1;
	143	8	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	112	75	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.3	1;
	193	51	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.22	1;
	193	40	0.0188	0.0122	0.0000163	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.12	0.0595	0.0000163	121.16	1;
	141	195	0.00397	0.00327	0.00000344	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0252	0.0125	0.00000344	30.75	1;
	175	193	0.0594	0.0351	0.0000515	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.377	0.188	0.0000515	373.46	1;
	121	189	0.0277	0.017	0.000024	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.176	0.0876	0.000024	176.59	1;
	103	204	0	0.0008	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	6.38	1;
	205	157	0.32	0.185	0.000279	6.04	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0	0	2.04	1.02	0.000279	2012.39	1;
	143	10	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.26	1;
	73	144	0.00879	0.00642	0.00000761	7.07	6.77	7.88	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0558	0.0278	0.00000761	62.7	1;
	148	117	0.004	0.00349	0.00000347	7.07	6.77	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0254	0.0127	0.00000347	30.5	1;
	80	117	0.000011	0.0004	2.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000011	0.0000242	2.33E-10	6.48	1;
	179	167	0.00371	0.00342	0.00000322	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0236	0.0117	0.00000322	26.33	1;
	187	179	0.392	0.225	0.00034	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	2.49	1.24	0.00034	2447.21	1;
	76	111	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.2	1;
	198	93	0.0000126	0.0005	2.66E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000126	0.0000276	2.66E-10	0.33	1;
	119	77	0.0000063	0.0004	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.22	1;
	125	188	0.0107	0.00732	0.00000929	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.068	0.0339	0.00000929	69.52	1;
	197	174	0.0532	0.0326	0.0000462	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.338	0.168	0.0000462	338.37	1;
	120	164	0.0167	0.0108	0.0000145	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.106	0.0529	0.0000145	108.68	1;
	119	78	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.16	1;
	9	132	0.0893	0.0377	0.000048	3.97	3.7066	4.1742	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.423	0.197	0.000048	388.25	1;
	118	189	0.0853	0.0504	0.0000739	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.542	0.27	0.0000739	542.99	1;
	121	190	0.037	0.0221	0.0000321	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.235	0.117	0.0000321	234.55	1;
	28	194	0	0.001	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	4.26	1;
	177	175	0.0194	0.0129	0.0000179	6.27	5.8717	6.5991	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.13	0.0655	0.0000179	134.15	1;
	86	177	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.14	1;
	48	190	0.0000063	0.0007	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	6.45	1;
	201	96	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.26	1;
	188	147	0.0191	0.0121	0.0000166	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.122	0.0605	0.0000166	123.92	1;
	202	130	0.0908	0.0531	0.0000787	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.576	0.287	0.0000787	569.41	1;
	191	124	0.0522	0.031	0.0000452	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.331	0.165	0.0000452	330.51	1;
	148	128	0.0871	0.0509	0.0000755	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.553	0.276	0.0000755	546.64	1;
	201	97	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.18	1;
	202	150	0.23	0.133	0.0002	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.46	0.728	0.0002	1439.77	1;
	60	191	0.0000063	0.0009	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	6.52	1;
	203	99	0	0.0004	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.17	1;
	123	141	0.091	0.0531	0.0000789	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.578	0.288	0.0000789	572.26	1;
	204	176	0.0229	0.0143	0.0000199	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.145	0.0724	0.0000199	147.07	1;
	152	176	0.028	0.017	0.0000243	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.178	0.0885	0.0000243	176.36	1;
	152	191	0.155	0.0897	0.000134	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.985	0.49	0.000134	971.81	1;
	145	83	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.21	1;
	128	144	0.0177	0.0113	0.0000154	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.113	0.0561	0.0000154	119.29	1;
	109	18	0.00212	0.00309	0.00000195	6.27	5.8717	6.5991	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0142	0.00714	0.00000195	25.69	1;
	146	84	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.22	1;
	149	117	0.313	0.18	0.000271	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.99	0.99	0.000271	1956.96	1;
	146	85	0.0000063	0.0004	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.29	1;
	203	110	0.1	0.0583	0.0000868	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.636	0.317	0.0000868	627.7	1;
	206	87	0.042	0.0255	0.0000364	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.267	0.133	0.0000364	268.05	1;
	206	106	0.0591	0.0349	0.0000512	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.375	0.187	0.0000512	373.08	1;
	195	196	0.105	0.0616	0.000091	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.667	0.332	0.000091	665.85	1;
	203	100	0	0.0003	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.25	1;
	116	136	0.437	0.251	0.000379	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	2.77	1.38	0.000379	2729.29	1;
	125	178	0.0165	0.0105	0.0000143	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.105	0.0522	0.0000143	105.56	1;
	32	125	0.0000063	0.0006	1.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000063	0.0000138	1.33E-10	0.58	1;
	142	120	0.0628	0.037	0.0000544	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.399	0.199	0.0000544	395.21	1;
	160	194	0.173	0.1	0.00015	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.1	0.546	0.00015	1081.5	1;
	133	168	0.0479	0.0293	0.0000459	6.04	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.325	0.164	0.0000459	327.87	1;
	207	138	0.21	0.122	0.000182	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.33	0.664	0.000182	1313.64	1;
	62	107	0.0575	0.0347	0.0000499	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.365	0.182	0.0000499	370.59	1;
	204	174	0.00264	0.0027	0.00000227	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0167	0.00832	0.00000227	20.45	1;
	131	35	0	0.0005	0	173	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.03	1;
	190	132	0.0191	0.0121	0.0000166	7.07	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.121	0.0605	0.0000166	123.72	1;
	45	151	0.00000788	0.0008	1.67E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00000788	0.0000173	1.67E-10	6.45	1;
	133	37	0.0000252	0.0007	5.33E-10	7.88	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0000252	0.0000552	5.33E-10	0.27	1;
	133	159	0.294	0.171	0.000262	6.04	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.9	0.95	0.000262	1878.2	1;
	107	149	0.238	0.138	0.00021	6.04	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.53	0.762	0.00021	1511.85	1;
	151	161	0.194	0.112	0.000168	7.07	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0	0	1.23	0.614	0.000168	1220.22	1;
];																										
																										
%%-----  OPF Data  -----%%																										
%% generator cost data																										
%	1	startup	shutdown	n	x1	y1	...	xn	yn																	
%	2	startup	shutdown	n	c(n-1)	...	c0																			
mpc.gencost = [																										
	2	0	0	3	0	0	  0.00;																			
];																										
																										
																										
% mpc.tans																										
% from bus	to bus	min	max	totaltaps	tap																					
mpc.trans=[2	1	0.8361	1.17	23	12];																					
																										
